import json

def convert_to_simple_format(input_file: str, output_file: str, sample_count: int = 300):
    with open(input_file, 'r', encoding='utf-8') as f:
        data = json.load(f)

    formatted_examples = []
    for item in data[:sample_count]:
        question = item.get('question', '').strip()
        facts = item.get('facts', [])
        if isinstance(facts, list):
            facts_str = ' '.join(str(f).strip() for f in facts)
        else:
            facts_str = str(facts).strip()
        answer = item.get('answer', '')
        if isinstance(answer, bool):
            answer_str = "True" if answer else "False"
        else:
            answer_str = str(answer).strip()
        example = f"Question: {question}\nFacts: {facts_str}\nAnswer: {answer_str}"
        formatted_examples.append(example)

    with open(output_file, 'w', encoding='utf-8') as f:
        f.write('\n\n'.join(formatted_examples))

if __name__ == '__main__':
    input_file = "strategyqa_train.json"
    output_file = "reasoning_output_strategyqa_300.txt"
    convert_to_simple_format(input_file, output_file)
    print(f"Conversion completed, output file saved to: {output_file}")
